@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.meusveiculo.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.meusveiculos.update", [$meusveiculo->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label class="required" for="placa">{{ trans('cruds.meusveiculo.fields.placa') }}</label>
                <input class="form-control {{ $errors->has('placa') ? 'is-invalid' : '' }}" type="text" name="placa" id="placa" value="{{ old('placa', $meusveiculo->placa) }}" required>
                @if($errors->has('placa'))
                    <span class="text-danger">{{ $errors->first('placa') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.placa_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="renavam">{{ trans('cruds.meusveiculo.fields.renavam') }}</label>
                <input class="form-control {{ $errors->has('renavam') ? 'is-invalid' : '' }}" type="text" name="renavam" id="renavam" value="{{ old('renavam', $meusveiculo->renavam) }}" required>
                @if($errors->has('renavam'))
                    <span class="text-danger">{{ $errors->first('renavam') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.renavam_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="chassi">{{ trans('cruds.meusveiculo.fields.chassi') }}</label>
                <input class="form-control {{ $errors->has('chassi') ? 'is-invalid' : '' }}" type="text" name="chassi" id="chassi" value="{{ old('chassi', $meusveiculo->chassi) }}">
                @if($errors->has('chassi'))
                    <span class="text-danger">{{ $errors->first('chassi') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.chassi_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="marca_modelo">{{ trans('cruds.meusveiculo.fields.marca_modelo') }}</label>
                <input class="form-control {{ $errors->has('marca_modelo') ? 'is-invalid' : '' }}" type="text" name="marca_modelo" id="marca_modelo" value="{{ old('marca_modelo', $meusveiculo->marca_modelo) }}">
                @if($errors->has('marca_modelo'))
                    <span class="text-danger">{{ $errors->first('marca_modelo') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.marca_modelo_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="cor">{{ trans('cruds.meusveiculo.fields.cor') }}</label>
                <input class="form-control {{ $errors->has('cor') ? 'is-invalid' : '' }}" type="text" name="cor" id="cor" value="{{ old('cor', $meusveiculo->cor) }}">
                @if($errors->has('cor'))
                    <span class="text-danger">{{ $errors->first('cor') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.cor_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="anomodelo">{{ trans('cruds.meusveiculo.fields.anomodelo') }}</label>
                <input class="form-control {{ $errors->has('anomodelo') ? 'is-invalid' : '' }}" type="text" name="anomodelo" id="anomodelo" value="{{ old('anomodelo', $meusveiculo->anomodelo) }}">
                @if($errors->has('anomodelo'))
                    <span class="text-danger">{{ $errors->first('anomodelo') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.anomodelo_helper') }}</span>
            </div>
            <div class="form-group">
                <label>{{ trans('cruds.meusveiculo.fields.status') }}</label>
                <select class="form-control {{ $errors->has('status') ? 'is-invalid' : '' }}" name="status" id="status">
                    <option value disabled {{ old('status', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\Meusveiculo::STATUS_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('status', $meusveiculo->status) === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('status'))
                    <span class="text-danger">{{ $errors->first('status') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.status_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="empresa">{{ trans('cruds.meusveiculo.fields.empresa') }}</label>
                <input class="form-control {{ $errors->has('empresa') ? 'is-invalid' : '' }}" type="text" name="empresa" id="empresa" value="{{ old('empresa', $meusveiculo->empresa) }}">
                @if($errors->has('empresa'))
                    <span class="text-danger">{{ $errors->first('empresa') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.empresa_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="cpfcnpj">{{ trans('cruds.meusveiculo.fields.cpfcnpj') }}</label>
                <input class="form-control {{ $errors->has('cpfcnpj') ? 'is-invalid' : '' }}" type="text" name="cpfcnpj" id="cpfcnpj" value="{{ old('cpfcnpj', $meusveiculo->cpfcnpj) }}">
                @if($errors->has('cpfcnpj'))
                    <span class="text-danger">{{ $errors->first('cpfcnpj') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.cpfcnpj_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="setor">{{ trans('cruds.meusveiculo.fields.setor') }}</label>
                <input class="form-control {{ $errors->has('setor') ? 'is-invalid' : '' }}" type="text" name="setor" id="setor" value="{{ old('setor', $meusveiculo->setor) }}">
                @if($errors->has('setor'))
                    <span class="text-danger">{{ $errors->first('setor') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.setor_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="seguradora">{{ trans('cruds.meusveiculo.fields.seguradora') }}</label>
                <input class="form-control {{ $errors->has('seguradora') ? 'is-invalid' : '' }}" type="text" name="seguradora" id="seguradora" value="{{ old('seguradora', $meusveiculo->seguradora) }}">
                @if($errors->has('seguradora'))
                    <span class="text-danger">{{ $errors->first('seguradora') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.seguradora_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="tag">{{ trans('cruds.meusveiculo.fields.tag') }}</label>
                <input class="form-control {{ $errors->has('tag') ? 'is-invalid' : '' }}" type="text" name="tag" id="tag" value="{{ old('tag', $meusveiculo->tag) }}">
                @if($errors->has('tag'))
                    <span class="text-danger">{{ $errors->first('tag') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.tag_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="observacao">{{ trans('cruds.meusveiculo.fields.observacao') }}</label>
                <textarea class="form-control ckeditor {{ $errors->has('observacao') ? 'is-invalid' : '' }}" name="observacao" id="observacao">{!! old('observacao', $meusveiculo->observacao) !!}</textarea>
                @if($errors->has('observacao'))
                    <span class="text-danger">{{ $errors->first('observacao') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.meusveiculo.fields.observacao_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection

@section('scripts')
<script>
    $(document).ready(function () {
  function SimpleUploadAdapter(editor) {
    editor.plugins.get('FileRepository').createUploadAdapter = function(loader) {
      return {
        upload: function() {
          return loader.file
            .then(function (file) {
              return new Promise(function(resolve, reject) {
                // Init request
                var xhr = new XMLHttpRequest();
                xhr.open('POST', '{{ route('admin.meusveiculos.storeCKEditorImages') }}', true);
                xhr.setRequestHeader('x-csrf-token', window._token);
                xhr.setRequestHeader('Accept', 'application/json');
                xhr.responseType = 'json';

                // Init listeners
                var genericErrorText = `Couldn't upload file: ${ file.name }.`;
                xhr.addEventListener('error', function() { reject(genericErrorText) });
                xhr.addEventListener('abort', function() { reject() });
                xhr.addEventListener('load', function() {
                  var response = xhr.response;

                  if (!response || xhr.status !== 201) {
                    return reject(response && response.message ? `${genericErrorText}\n${xhr.status} ${response.message}` : `${genericErrorText}\n ${xhr.status} ${xhr.statusText}`);
                  }

                  $('form').append('<input type="hidden" name="ck-media[]" value="' + response.id + '">');

                  resolve({ default: response.url });
                });

                if (xhr.upload) {
                  xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                      loader.uploadTotal = e.total;
                      loader.uploaded = e.loaded;
                    }
                  });
                }

                // Send request
                var data = new FormData();
                data.append('upload', file);
                data.append('crud_id', '{{ $meusveiculo->id ?? 0 }}');
                xhr.send(data);
              });
            })
        }
      };
    }
  }

  var allEditors = document.querySelectorAll('.ckeditor');
  for (var i = 0; i < allEditors.length; ++i) {
    ClassicEditor.create(
      allEditors[i], {
        extraPlugins: [SimpleUploadAdapter]
      }
    );
  }
});
</script>

@endsection