@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.menuMultum.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.menu-multa.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.placa') }}
                        </th>
                        <td>
                            {{ $menuMultum->placa }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.auto') }}
                        </th>
                        <td>
                            {{ $menuMultum->auto }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.infracao') }}
                        </th>
                        <td>
                            {{ $menuMultum->infracao }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.orgao_competente') }}
                        </th>
                        <td>
                            {{ $menuMultum->orgao_competente }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.local') }}
                        </th>
                        <td>
                            {{ $menuMultum->local }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.condutor') }}
                        </th>
                        <td>
                            {{ $menuMultum->condutor->nome ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.situacao') }}
                        </th>
                        <td>
                            {{ $menuMultum->situacao }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.data_infracao') }}
                        </th>
                        <td>
                            {{ $menuMultum->data_infracao }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.valor_total') }}
                        </th>
                        <td>
                            {{ $menuMultum->valor_total }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.vencimento_auto') }}
                        </th>
                        <td>
                            {{ $menuMultum->vencimento_auto }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.infracao_autoriazada') }}
                        </th>
                        <td>
                            {{ App\Models\MenuMultum::INFRACAO_AUTORIAZADA_SELECT[$menuMultum->infracao_autoriazada] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.pagamento_disponivel') }}
                        </th>
                        <td>
                            {{ App\Models\MenuMultum::PAGAMENTO_DISPONIVEL_SELECT[$menuMultum->pagamento_disponivel] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.statuspagamento') }}
                        </th>
                        <td>
                            {{ App\Models\MenuMultum::STATUSPAGAMENTO_SELECT[$menuMultum->statuspagamento] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.gera_nic') }}
                        </th>
                        <td>
                            {{ App\Models\MenuMultum::GERA_NIC_SELECT[$menuMultum->gera_nic] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.menuMultum.fields.auto_gerador') }}
                        </th>
                        <td>
                            {{ $menuMultum->auto_gerador }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.menu-multa.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection