<?php

namespace App\Http\Requests;

use App\Models\Meuscondutore;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreMeuscondutoreRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('meuscondutore_create');
    }

    public function rules()
    {
        return [
            'nome' => [
                'string',
                'required',
            ],
            'numregistro' => [
                'string',
                'required',
                'unique:meuscondutores',
            ],
            'uf' => [
                'required',
            ],
            'validade' => [
                'date_format:' . config('panel.date_format'),
                'nullable',
            ],
            'categoria' => [
                'string',
                'nullable',
            ],
            'status' => [
                'required',
            ],
        ];
    }
}
