<?php

namespace App\Http\Requests;

use App\Models\DebitosGerai;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroyDebitosGeraiRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('debitos_gerai_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:debitos_gerais,id',
        ];
    }
}
