<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\MediaUploadingTrait;
use App\Http\Requests\StoreMeusveiculoRequest;
use App\Http\Requests\UpdateMeusveiculoRequest;
use App\Http\Resources\Admin\MeusveiculoResource;
use App\Models\Meusveiculo;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class MeusveiculosApiController extends Controller
{
    use MediaUploadingTrait;

    public function index()
    {
        abort_if(Gate::denies('meusveiculo_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new MeusveiculoResource(Meusveiculo::with(['team'])->get());
    }

    public function store(StoreMeusveiculoRequest $request)
    {
        $meusveiculo = Meusveiculo::create($request->all());

        return (new MeusveiculoResource($meusveiculo))
            ->response()
            ->setStatusCode(Response::HTTP_CREATED);
    }

    public function show(Meusveiculo $meusveiculo)
    {
        abort_if(Gate::denies('meusveiculo_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return new MeusveiculoResource($meusveiculo->load(['team']));
    }

    public function update(UpdateMeusveiculoRequest $request, Meusveiculo $meusveiculo)
    {
        $meusveiculo->update($request->all());

        return (new MeusveiculoResource($meusveiculo))
            ->response()
            ->setStatusCode(Response::HTTP_ACCEPTED);
    }

    public function destroy(Meusveiculo $meusveiculo)
    {
        abort_if(Gate::denies('meusveiculo_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $meusveiculo->delete();

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
