<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroyMeuscondutoreRequest;
use App\Http\Requests\StoreMeuscondutoreRequest;
use App\Http\Requests\UpdateMeuscondutoreRequest;
use App\Models\Meuscondutore;
use App\Models\Team;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class MeuscondutoresController extends Controller
{
    use CsvImportTrait;

    public function index(Request $request)
    {
        abort_if(Gate::denies('meuscondutore_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = Meuscondutore::with(['team'])->select(sprintf('%s.*', (new Meuscondutore)->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate      = 'meuscondutore_show';
                $editGate      = 'meuscondutore_edit';
                $deleteGate    = 'meuscondutore_delete';
                $crudRoutePart = 'meuscondutores';

                return view('partials.datatablesActions', compact(
                    'viewGate',
                    'editGate',
                    'deleteGate',
                    'crudRoutePart',
                    'row'
                ));
            });

            $table->editColumn('nome', function ($row) {
                return $row->nome ? $row->nome : '';
            });
            $table->editColumn('numregistro', function ($row) {
                return $row->numregistro ? $row->numregistro : '';
            });
            $table->editColumn('uf', function ($row) {
                return $row->uf ? Meuscondutore::UF_SELECT[$row->uf] : '';
            });

            $table->editColumn('categoria', function ($row) {
                return $row->categoria ? $row->categoria : '';
            });
            $table->editColumn('status', function ($row) {
                return $row->status ? Meuscondutore::STATUS_SELECT[$row->status] : '';
            });

            $table->rawColumns(['actions', 'placeholder']);

            return $table->make(true);
        }

        $teams = Team::get();

        return view('admin.meuscondutores.index', compact('teams'));
    }

    public function create()
    {
        abort_if(Gate::denies('meuscondutore_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.meuscondutores.create');
    }

    public function store(StoreMeuscondutoreRequest $request)
    {
        $meuscondutore = Meuscondutore::create($request->all());

        return redirect()->route('admin.meuscondutores.index');
    }

    public function edit(Meuscondutore $meuscondutore)
    {
        abort_if(Gate::denies('meuscondutore_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $meuscondutore->load('team');

        return view('admin.meuscondutores.edit', compact('meuscondutore'));
    }

    public function update(UpdateMeuscondutoreRequest $request, Meuscondutore $meuscondutore)
    {
        $meuscondutore->update($request->all());

        return redirect()->route('admin.meuscondutores.index');
    }

    public function show(Meuscondutore $meuscondutore)
    {
        abort_if(Gate::denies('meuscondutore_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $meuscondutore->load('team');

        return view('admin.meuscondutores.show', compact('meuscondutore'));
    }

    public function destroy(Meuscondutore $meuscondutore)
    {
        abort_if(Gate::denies('meuscondutore_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $meuscondutore->delete();

        return back();
    }

    public function massDestroy(MassDestroyMeuscondutoreRequest $request)
    {
        $meuscondutores = Meuscondutore::find(request('ids'));

        foreach ($meuscondutores as $meuscondutore) {
            $meuscondutore->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
