<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroyCondutoreRequest;
use App\Http\Requests\StoreCondutoreRequest;
use App\Http\Requests\UpdateCondutoreRequest;
use App\Models\Condutore;
use App\Models\Team;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class CondutoresController extends Controller
{
    use CsvImportTrait;

    public function index(Request $request)
    {
        abort_if(Gate::denies('condutore_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = Condutore::with(['team'])->select(sprintf('%s.*', (new Condutore)->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate      = 'condutore_show';
                $editGate      = 'condutore_edit';
                $deleteGate    = 'condutore_delete';
                $crudRoutePart = 'condutores';

                return view('partials.datatablesActions', compact(
                    'viewGate',
                    'editGate',
                    'deleteGate',
                    'crudRoutePart',
                    'row'
                ));
            });

            $table->editColumn('nome', function ($row) {
                return $row->nome ? $row->nome : '';
            });
            $table->editColumn('numero_registro', function ($row) {
                return $row->numero_registro ? $row->numero_registro : '';
            });
            $table->editColumn('categoria', function ($row) {
                return $row->categoria ? $row->categoria : '';
            });

            $table->editColumn('situacao', function ($row) {
                return $row->situacao ? $row->situacao : '';
            });
            $table->editColumn('pontuacao', function ($row) {
                return $row->pontuacao ? $row->pontuacao : '';
            });

            $table->rawColumns(['actions', 'placeholder']);

            return $table->make(true);
        }

        $teams = Team::get();

        return view('admin.condutores.index', compact('teams'));
    }

    public function create()
    {
        abort_if(Gate::denies('condutore_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.condutores.create');
    }

    public function store(StoreCondutoreRequest $request)
    {
        $condutore = Condutore::create($request->all());

        return redirect()->route('admin.condutores.index');
    }

    public function edit(Condutore $condutore)
    {
        abort_if(Gate::denies('condutore_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $condutore->load('team');

        return view('admin.condutores.edit', compact('condutore'));
    }

    public function update(UpdateCondutoreRequest $request, Condutore $condutore)
    {
        $condutore->update($request->all());

        return redirect()->route('admin.condutores.index');
    }

    public function show(Condutore $condutore)
    {
        abort_if(Gate::denies('condutore_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $condutore->load('team');

        return view('admin.condutores.show', compact('condutore'));
    }

    public function destroy(Condutore $condutore)
    {
        abort_if(Gate::denies('condutore_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $condutore->delete();

        return back();
    }

    public function massDestroy(MassDestroyCondutoreRequest $request)
    {
        $condutores = Condutore::find(request('ids'));

        foreach ($condutores as $condutore) {
            $condutore->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
